/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.HorizontalWallRunAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.WallJump;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class HorizontalWallRun
extends Action {
    private int coolTime = 0;
    private float bodyYaw = 0.0f;
    private static final int Max_Running_Tick = (Integer)ParCoolConfig.CONFIG_CLIENT.wallRunContinuableTick.get();
    private boolean wallIsRightward = false;
    private Vec3 runningWallDirection = null;

    @Override
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.coolTime > 0) {
            --this.coolTime;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        Vec3 wallDirection = WorldUtil.getRunnableWall((LivingEntity)player, player.m_20205_());
        if (wallDirection == null) {
            return;
        }
        Vec3 targetVec = wallDirection.m_82524_((float)(this.wallIsRightward ? 1 : -1) * (float)Math.PI / 2.0f);
        Vec3 lookVec = player.m_20154_();
        double differenceAngle = Math.asin(new Vec3((double)(lookVec.f_82479_ * targetVec.f_82479_ + lookVec.f_82481_ * targetVec.f_82481_), (double)0.0, (double)(-lookVec.f_82479_ * targetVec.f_82481_ + lookVec.f_82481_ * targetVec.f_82479_)).m_82541_().f_82481_);
        this.bodyYaw = (float)VectorUtil.toYawDegree(targetVec.m_82524_((float)(differenceAngle / 10.0)));
        if (this.runningWallDirection == null) {
            return;
        }
        Vec3 movement = player.m_20184_();
        BlockPos leanedBlock = new BlockPos(player.m_20185_() + this.runningWallDirection.f_82479_, player.m_20186_() + (double)player.m_20206_() * 0.5, player.m_20189_() + this.runningWallDirection.f_82481_);
        if (!player.f_19853_.m_46749_(leanedBlock)) {
            return;
        }
        float slipperiness = player.f_19853_.m_8055_(leanedBlock).getFriction((LevelReader)player.f_19853_, leanedBlock, (Entity)player);
        if ((double)slipperiness <= 0.8) {
            player.m_20334_(movement.f_82479_, movement.f_82480_ * ((double)slipperiness - 0.1) * (double)this.getDoingTick() / (double)Max_Running_Tick, movement.f_82481_);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vec3 wallDirection = WorldUtil.getRunnableWall((LivingEntity)player, player.m_20205_());
        if (wallDirection == null) {
            return false;
        }
        Vec3 wallVec = wallDirection.m_82541_();
        Vec3 direction = VectorUtil.fromYawDegree(player.f_20883_);
        direction = new Vec3(direction.f_82479_, 0.0, direction.f_82481_).m_82541_();
        Vec3 dividedVec = new Vec3(wallVec.f_82479_ * direction.f_82479_ + wallVec.f_82481_ * direction.f_82481_, 0.0, -wallVec.f_82479_ * direction.f_82481_ + wallVec.f_82481_ * direction.f_82479_).m_82541_();
        if (Math.abs(dividedVec.f_82481_) < 0.9) {
            return false;
        }
        BufferUtil.wrap(startInfo).putBoolean(dividedVec.f_82481_ > 0.0);
        startInfo.putDouble(wallDirection.f_82479_).putDouble(wallDirection.f_82481_);
        return parkourability.getActionInfo().can(HorizontalWallRun.class) && !parkourability.get(WallJump.class).justJumped() && !parkourability.get(Crawl.class).isDoing() && KeyBindings.getKeyHorizontalWallRun().m_90857_() && Math.abs(player.m_20184_().f_82480_) < 0.3 && this.coolTime == 0 && !player.m_20096_() && parkourability.getAdditionalProperties().getNotLandingTick() > 5 && (parkourability.get(FastRun.class).canActWithRunning(player) || parkourability.get(FastRun.class).getNotDashTick(parkourability.getAdditionalProperties()) < 10) && !stamina.isExhausted();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        Vec3 wallDirection = WorldUtil.getRunnableWall((LivingEntity)player, player.m_20205_());
        if (wallDirection == null) {
            return false;
        }
        return this.getDoingTick() < Max_Running_Tick && !stamina.isExhausted() && parkourability.getActionInfo().can(HorizontalWallRun.class) && !parkourability.get(WallJump.class).justJumped() && !parkourability.get(Crawl.class).isDoing() && KeyBindings.getKeyHorizontalWallRun().m_90857_() && !player.m_20096_();
    }

    @Override
    public void onStop(Player player) {
        this.coolTime = 10;
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        this.wallIsRightward = BufferUtil.getBoolean(startData);
        this.runningWallDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new HorizontalWallRunAnimator(this.wallIsRightward));
        }
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.wallIsRightward = BufferUtil.getBoolean(startData);
        this.runningWallDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new HorizontalWallRunAnimator(this.wallIsRightward));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
        if (this.isDoing()) {
            player.m_146922_(this.bodyYaw);
        }
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putFloat(this.bodyYaw);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.bodyYaw = buffer.getFloat();
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }
}

